/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.items.ItemResourceScroll;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceScrollSaveWarehouseSnapshotMessage
implements IMessage {
    @NotNull
    private BlockPos builderPos = BlockPos.field_177992_a;
    @NotNull
    private Map<String, Integer> snapshot = new HashMap<String, Integer>();
    @NotNull
    private String workOrderHash = "";

    public ResourceScrollSaveWarehouseSnapshotMessage() {
    }

    public ResourceScrollSaveWarehouseSnapshotMessage(@NotNull BlockPos builderPos, @NotNull Map<String, Integer> snapshot, @NotNull String workOrderHash) {
        this.builderPos = builderPos;
        this.snapshot = snapshot;
        this.workOrderHash = workOrderHash;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.builderPos = buf.func_179259_c();
        int numItems = buf.readInt();
        this.snapshot = new HashMap<String, Integer>();
        for (int i = 0; i < numItems; ++i) {
            String itemName = buf.func_150789_c(Short.MAX_VALUE);
            int itemAmount = buf.readInt();
            this.snapshot.put(itemName, itemAmount);
        }
        this.workOrderHash = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_179255_a(this.builderPos);
        buf.writeInt(this.snapshot.size());
        this.snapshot.forEach((key, value) -> {
            buf.func_180714_a(key);
            buf.writeInt(value.intValue());
        });
        buf.func_180714_a(this.workOrderHash);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Objects.requireNonNull(ctxIn.getSender()).field_71071_by.field_70462_a.stream().filter(stack -> stack.func_77973_b() instanceof ItemResourceScroll).filter(stack -> stack.func_77978_p() != null).filter(stack -> this.builderPos.equals((Object)BlockPosUtil.read(stack.func_77978_p(), "builder"))).forEach(stack -> {
            CompoundNBT data = stack.func_77978_p();
            CompoundNBT newData = new CompoundNBT();
            this.snapshot.keySet().forEach(f -> newData.func_74768_a(f, this.snapshot.getOrDefault(f, 0).intValue()));
            data.func_218657_a("version", (INBT)newData);
            data.func_74778_a("wo_hash", this.workOrderHash);
        });
    }
}

